'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Report_Open(Cancel As Integer)
    SchriftartFuerBerichtEinstellen Me
    
    'berschrift der Rechnung einstellen
    Me.Ueberschrift.Caption = FormularRechnungUeberschrift
    
    'berschrift fr Dauer einstellen
    Select Case FormatTermindauer
        Case 0      'Minuten  (Bsp.: 105)
            Me.Dauer_Bezeichnungsfeld.Caption = "Minuten"
        Case 4      'Dezimalstunden  (1,75)
            Me.Dauer_Bezeichnungsfeld.Caption = "Std"
        Case 8      'Std:Min  (01:45)
            Me.Dauer_Bezeichnungsfeld.Caption = "Std:Min"
        Case Else
            Me.Dauer_Bezeichnungsfeld.Caption = "Minuten"
    End Select
    
    'aktuelles Whrungsformat des Systems einstellen
    Me.Re_Netto.Format = "Currency"
    Me.Re_MwSt.Format = "Currency"
    Me.Re_Brutto.Format = "Currency"
End Sub
